/* 
	Copyright 1988-2000 by Autodesk, Inc.

	Permission to use, copy, modify, and distribute this software
	for any purpose and without fee is hereby granted, provided
	that the above copyright notice appears in all copies and
	that both that copyright notice and the limited warranty and
	restricted rights notice below appear in all supporting
	documentation.

	AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
	AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
	MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
	DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
	UNINTERRUPTED OR ERROR FREE.

	Use, duplication, or disclosure by the U.S. Government is subject to
	restrictions set forth in FAR 52.227-19 (Commercial Computer
	Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii) 
	(Rights in Technical Data and Computer Software), as applicable.

    Autodesk Publish to Web JavaScript 
    
    Template element id: adsk_ptw_array_of_thumbnails
    Publishing content:  image
                         label
                         description
                         idrop

    Template element id: adsk_ptw_summary_frame
    Publishing content:  drawing summary
*/

adsk_ptw_array_of_thumbnails_main();

function adsk_ptw_array_of_thumbnails_main() {

    var n=4; 
    var table_width="700"; 
    
    var xmle=adsk_ptw_xml.getElementsByTagName("publish_to_web").item(0);
    xmle=xmle.getElementsByTagName("contents").item(0);
    var xmles=xmle.getElementsByTagName("content");
    var e = document.getElementById("adsk_ptw_array_of_thumbnails");
    table = document.createElement("table");
    table.cellSpacing=10; 
    tbody = document.createElement("tbody");
    e.appendChild(table);
    table.appendChild(tbody);
    table.width="100%";
    tbody.appendChild(document.createElement("tr")); 

    var isDWF=false;
    for (i=0; i < xmles.length; i++) {
        if ((0==i) || (0 == (i % n))) { 
            tr = document.createElement("tr");
            tr2 = document.createElement("tr");
            tr3 = document.createElement("tr"); 
            tbody.appendChild(tr);
            tbody.appendChild(tr2);
            tbody.appendChild(document.createElement("tr"));
            tbody.appendChild(document.createElement("tr"));
            tr.align="left";
            tr.vAlign="top"
            tr2.align="left";
            tr2.vAlign="top"
        }  
        td = document.createElement("td"); 
        td2 = document.createElement("td"); 
        tr.appendChild(td);
        tr2.appendChild(td2);  
        td.width=table_width / n; 
        td2.width=table_width / n; 
        td2.align="left";
        td2.vAlign="top";
        content=xmles.item(i);     
        image=content.getElementsByTagName("imagex").item(0);
        a=document.createElement("a"); 
        td.appendChild(a);
        a.value=image.firstChild.data;
        a.href="javascript:adsk_ptw_array_of_thumbnails_onClickImage()";
        thumb=content.getElementsByTagName("thumbnail").item(0);
        img = document.createElement("image");
        a.appendChild(img);
        img.src = thumb.firstChild.data; 
        img.border=1; 
        img.onmouseover=function() { adsk_ptw_array_of_thumbnails_mouse_over(); }
        img.onmouseout=function() { adsk_ptw_array_of_thumbnails_mouse_out(); }
        img.name=i;

        idrop = content.getElementsByTagName("iDropXML").item(0);
        if (null != idrop.firstChild) {
            br = document.createElement("br");
            td.appendChild(br);
            activex = document.createElement("object");
            td.appendChild(activex);
            activex.codeBase=xmsg_adsk_ptw_all_idrop_url;
//Checking appVersion to load appropriate ActiveX control( 32-bit or 64-bit )
            var appVersionName = navigator.appVersion;
            var index = appVersionName.indexOf("x64");
            if(index != -1 )
            {
                activex.classid="clsid:32290CD1-D585-4803-AF20-F16E20FF377A";
            }
            else
            {
                activex.classid="clsid:21E0CB95-1198-4945-A3D2-4BF804295F78";
            }
            
            activex.package=idrop.firstChild.data;
            activex.background="iDropButton.gif";
            activex.width="16";
            activex.height="16";
        }

        a2=document.createElement("a"); 
        td2.appendChild(a2);
        a2.className="DRAWING_LABEL";   
        a2.value=image.firstChild.data;
        a2.href="javascript:adsk_ptw_array_of_thumbnails_onClickImage()";

        if (!isDWF) {
            isDWF=adsk_ptw_validate_viewer_is_dwf_file(image.firstChild.data);
        }

        title=content.getElementsByTagName("title").item(0);
        if (null == title.firstChild) {
            a2.appendChild(document.createTextNode(" "));
        }
        else {
            a2.appendChild(document.createTextNode(title.firstChild.data));
        }
        td2.appendChild(document.createElement("br"));

        div=document.createElement("div");
        td2.appendChild(div);
        div.className="DRAWING_DESCRIPTION";  
        desc = content.getElementsByTagName("description").item(0);
        if (null == desc.firstChild) {
            div.appendChild(document.createTextNode(""));
        }
        else {
            div.appendChild(document.createTextNode(desc.firstChild.data));
        }
    }
    if (isDWF) {
        viewerInstalled = false;
        IE4plus = (document.all) ? true : false;
	    if (IE4plus)
	        // try and catch work fine in IE, but will generate errors in Netscape. So evaluating try and catch block as string and evaluate it usung eval fuction
  	        eval ('try {var xObj = new ActiveXObject("AdView.Adviewer");if (xObj == null) viewerInstalled = false; else viewerInstalled = true; } catch (e) { viewerInstalled = false; }');

	    if (viewerInstalled) {
		    activex = document.createElement("object");
	        activex.classid="clsid:A662DA7E-CCB7-4743-B71A-D817F6D575DF";
	    }
	    else
		    adsk_ptw_onerror(); // Redirects the user to a website where they can download Autodest Express Viewer
    }
}

function adsk_ptw_array_of_thumbnails_onClickImage() {
    parent.window.navigate(document.activeElement.value);
}

function adsk_ptw_array_of_thumbnails_mouse_over() {
    if (null == parent) return;
    if (null == parent.adsk_ptw_summary_frame) return;

    i=window.event.srcElement.name;

    var xmle=adsk_ptw_xml.getElementsByTagName("publish_to_web").item(0);
    xmle=xmle.getElementsByTagName("contents").item(0);
    var xmles=xmle.getElementsByTagName("content");
    sum_info = xmles.item(i).getElementsByTagName("summary_info").item(0);

    if (null != sum_info) {
        body=parent.adsk_ptw_summary_frame.document.getElementsByTagName("body").item(0);

        title=sum_info.getElementsByTagName("title").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summaryTitle, title);

        subject=sum_info.getElementsByTagName("subject").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summarySubject, subject);

        author=sum_info.getElementsByTagName("author").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summaryAuthor, author);

        keywords=sum_info.getElementsByTagName("keywords").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summaryKeywords, keywords);

        comments=sum_info.getElementsByTagName("comments").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summaryComments, comments);
        
        hyperlink_base=sum_info.getElementsByTagName("hyperlink_base").item(0);
        adsk_ptw_array_of_thumbnails_summary(body, xmsg_adsk_ptw_all_summaryHyperlinkBase, hyperlink_base);
    }
}

function adsk_ptw_array_of_thumbnails_mouse_out() {
    if (null == parent) return;
    if (null == parent.adsk_ptw_summary_frame) return;

    body=parent.adsk_ptw_summary_frame.document.getElementsByTagName("body").item(0);
    n=body.childNodes.length;
    for (i=0; i < n; i++) {
        body.removeChild(body.firstChild);
    }
}

function adsk_ptw_array_of_thumbnails_summary(rootNode, nameString, valueNode) {
    if (null == valueNode) return;
    if (null == valueNode.firstChild) return;

    b=parent.adsk_ptw_summary_frame.document.createElement("b");
    div=parent.adsk_ptw_summary_frame.document.createElement("div");
    rootNode.appendChild(div);
    div.appendChild(b);
    str = nameString + valueNode.firstChild.data;
    b.appendChild(parent.adsk_ptw_summary_frame.document.createTextNode(str));
}



// SIG // Begin signature block
// SIG // MIIpKQYJKoZIhvcNAQcCoIIpGjCCKRYCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // c3Tz6PixXNhVeU4QLU2oqwI8co5fpy0YGDRwxwoPkv6g
// SIG // gg4ZMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
// SIG // 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
// SIG // MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
// SIG // d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
// SIG // dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
// SIG // WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
// SIG // hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
// SIG // XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
// SIG // 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
// SIG // ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
// SIG // ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
// SIG // GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
// SIG // XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
// SIG // GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
// SIG // R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
// SIG // wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
// SIG // k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
// SIG // M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
// SIG // UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
// SIG // FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
// SIG // JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
// SIG // 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
// SIG // CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
// SIG // MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
// SIG // CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
// SIG // upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
// SIG // BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
// SIG // BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
// SIG // cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
// SIG // QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
// SIG // aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
// SIG // cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
// SIG // DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
// SIG // 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
// SIG // fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
// SIG // WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
// SIG // YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
// SIG // WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
// SIG // Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
// SIG // H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
// SIG // 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
// SIG // 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
// SIG // 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
// SIG // i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
// SIG // KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
// SIG // bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
// SIG // ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
// SIG // SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
// SIG // VnhOMIIHYTCCBUmgAwIBAgIQCH7hieqmtSvEO2+hkIpM
// SIG // XDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
// SIG // MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
// SIG // OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
// SIG // IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMDcx
// SIG // NzAwMDAwMFoXDTI0MDcxNjIzNTk1OVowaTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEzARBgNV
// SIG // BAcTClNhbiBSYWZhZWwxFzAVBgNVBAoTDkF1dG9kZXNr
// SIG // LCBJbmMuMRcwFQYDVQQDEw5BdXRvZGVzaywgSW5jLjCC
// SIG // AiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAKKc
// SIG // yDoWrxsL4jV3XIRZUqz//dBldginxx6FQA0LWptqdL0+
// SIG // FUS1mzcT9W2lcIXG+VQFguY9sgJcvYSTnQmbIchKptvw
// SIG // CaJQvOo6+mLEIFiWgP2RuF67L8jRB61Q1+gcN35eLLnK
// SIG // 4runGSVGP0mtLWYSL2ryuWu5Y8VYRfnZHWwa84bqh0UW
// SIG // IAmhArTWl6LqufLTqgNpQTOAfZk5oAkBpRCFkSgzP8hm
// SIG // 2adhANyLh0iFWalGMz4WqZXdMRdCAtpQ15eJsTDbFmnr
// SIG // QBZ4/noX6XXFm2t/RvGkYg82VMiHnul9xRLEurfW+EO+
// SIG // FEQ58X00ee5ZGrUgJZeqdaQranLnhkAMp1k8qdtPPG9h
// SIG // /hfmi+4oBt+u2MfyeQFS/JglunH8L80NLbrrOjvVVKZz
// SIG // UVrRU34knt7yzbQyK8ogqGSL9BPZPumP8rc77H6SvoSu
// SIG // btiqEw0Ru4vb9BvjyuhtbS50qlPBM1wRQyfa89ITDsP3
// SIG // gc83ziWCLFHcU0KQ4akG8PvqERTybmlq5do4QWU1Z6tK
// SIG // YNTd3v+fur+xrvzqFDlyCi1YKCA04bkfkLg6bupNEe4N
// SIG // sJKt0M1A+HDmadcIj0GIfnhvsmPsQQQ5nM6umQu67IUL
// SIG // ccUJtzC9IYhqk9iLDRKMGXr8LIV4EmyDaAItYiFe/ndj
// SIG // KSDMx9KDlUfGLD1KCpxxAgMBAAGjggIDMIIB/zAfBgNV
// SIG // HSMEGDAWgBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNV
// SIG // HQ4EFgQUP+qYY98y1gz7twN8OhZPK8gWlmswDgYDVR0P
// SIG // AQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1
// SIG // BgNVHR8Ega0wgaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRp
// SIG // Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVT
// SIG // aWduaW5nUlNBNDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOg
// SIG // UaBPhk1odHRwOi8vY3JsNC5kaWdpY2VydC5jb20vRGln
// SIG // aUNlcnRUcnVzdGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZT
// SIG // SEEzODQyMDIxQ0ExLmNybDA+BgNVHSAENzA1MDMGBmeB
// SIG // DAEEATApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3LmRp
// SIG // Z2ljZXJ0LmNvbS9DUFMwgZQGCCsGAQUFBwEBBIGHMIGE
// SIG // MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2Vy
// SIG // dC5jb20wXAYIKwYBBQUHMAKGUGh0dHA6Ly9jYWNlcnRz
// SIG // LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENv
// SIG // ZGVTaWduaW5nUlNBNDA5NlNIQTM4NDIwMjFDQTEuY3J0
// SIG // MAkGA1UdEwQCMAAwDQYJKoZIhvcNAQELBQADggIBADM5
// SIG // oKAJ/GLdOA6cwT5Z+wAM5//a/CRnOKdheKmGtwzqsD8Z
// SIG // R93gSG18BCgn255uAVwzAyCS9mi3AI8uRJlIM6dij/1q
// SIG // mmJFJ3Ji3vPj8s5sSOZ7zNbkcCDS2haFXSFfhYyNQUkU
// SIG // aZkNgg1pCIK2asuDx8i6HYXihNWVEw0AFZ4ovvVK8G5P
// SIG // crb3nPpRgUGXRTno5UaHnAaD/7u2FP4rKr9DlNxdZuM6
// SIG // nerlKL9i3888lm7VQQ8ptMMq9f1XeBq+BcJF2HbO7iaO
// SIG // ayFZKuf/Hn3XH8t+SMHEP2N+3ESLT/YxwSpMp0st2t+D
// SIG // cTd7TntatIbnZYqal4G3L17Pr/euG9rq2RehiS3eBFox
// SIG // wgBTI46iW0SpOyeYMYbECeoenlZziCjY8y/alYv+xyWT
// SIG // PSL3oV0qACfvjXyuG5VD4jCEjhHP08QA1dma9ROyDz0q
// SIG // OKuei8QaOiWrgq6LFAFaMYZHGw8jE3Us9Hk/cFUrhz3Q
// SIG // AyeDgza57Uatp2X/hO94Q89KxmwduXTnY+LD40miitsI
// SIG // srIR+v6M/exAPetl7oHp92C6n4r/ArtbVoH/YYjh10hi
// SIG // tZNq1xcwLx8MIIJh5W1fuVZDy3oJP1VfH3wlDjwFmIuN
// SIG // aleEDksdEsJ97OfTwXc1o9fT8OpBIiDpjj4UEd24JcPl
// SIG // FoGOc+mG0Qk3J4MlG/T9MYIaaDCCGmQCAQEwfTBpMQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
// SIG // Yy4xQTA/BgNVBAMTOERpZ2lDZXJ0IFRydXN0ZWQgRzQg
// SIG // Q29kZSBTaWduaW5nIFJTQTQwOTYgU0hBMzg0IDIwMjEg
// SIG // Q0ExAhAIfuGJ6qa1K8Q7b6GQikxcMA0GCWCGSAFlAwQC
// SIG // AQUAoHwwEAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcN
// SIG // AQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEO
// SIG // MAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIAEK
// SIG // LQKvqkz+WzgXFkyCmTeOzkogykvVER+4HLjyYpM3MA0G
// SIG // CSqGSIb3DQEBAQUABIICAGFrhWdM/TyIpOEwIBj/5cya
// SIG // Olv+GiCDtrPJ26FziDcF34yhsCAJZnGA5u0wk1GZ4DWH
// SIG // pfY83T3Ohv8EpMidVOlYdqptvh3GOjflykDlqbbYtK+w
// SIG // CfOiMY6xHwMoGUfXBlWKuXgoylaCiBpcxxK7w/FNp7T9
// SIG // NChswB8heMmvkay4Kgmtc5scvLVmWVgfUUpqoeJE7cKR
// SIG // o3lH/jS9I565rNthxiZOy//DuvsWAKTUVeOwLG7u1JJu
// SIG // 0v21Vchc/jDRnF95fgiz1cGI6IiqCsBnxur5eKmORqyg
// SIG // jgjmuxgg3qd1kc/HaIEwLtkODIz0MB75Ta0jW+CAakDR
// SIG // Ry7WwWN+G+oV/hK02BO33InLjOGFnv4rjRAAU8o3HSzk
// SIG // Hx5fgimz/+Oufze2xSyhwcLsoh8fgKZBEcXrjqVxzrZH
// SIG // 7GIYqt37TXk9S9aLkrU0kjy5D2A8VFjz1Fn9y6AbTNb+
// SIG // gBGAmaBiqXZKz85qOL4TVK/xZh13wxMztGYz1r4to5c4
// SIG // uC8E5k1tQDYXnCOtEx+AROn+uK06i+nfTr5v7Va7LTDH
// SIG // CwnDLQN1hScYKOjzUsOC+zmaAT0Vvi6UVFJvs3hLtZEi
// SIG // 9sh/4+GtjbaHXKR2ZiCg5y/WNqXUOY7r6UuFnWQLiGhr
// SIG // YnKzk4DPfsvskzITEHlJSy126GVzPW+s9zjDOr47cNS+
// SIG // oYIXPjCCFzoGCisGAQQBgjcDAwExghcqMIIXJgYJKoZI
// SIG // hvcNAQcCoIIXFzCCFxMCAQMxDzANBglghkgBZQMEAgEF
// SIG // ADB4BgsqhkiG9w0BCRABBKBpBGcwZQIBAQYJYIZIAYb9
// SIG // bAcBMDEwDQYJYIZIAWUDBAIBBQAEIJfOfGPhITBXLMW5
// SIG // nKhCm4gFFQPE0QG6chFB2rhY22iaAhEA4naSppWP3erd
// SIG // V/Y8jwgZrRgPMjAyMzA4MDIwMzExNDRaoIITBzCCBsAw
// SIG // ggSooAMCAQICEAxNaXJLlPo8Kko9KQeAPVowDQYJKoZI
// SIG // hvcNAQELBQAwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
// SIG // DkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
// SIG // dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVT
// SIG // dGFtcGluZyBDQTAeFw0yMjA5MjEwMDAwMDBaFw0zMzEx
// SIG // MjEyMzU5NTlaMEYxCzAJBgNVBAYTAlVTMREwDwYDVQQK
// SIG // EwhEaWdpQ2VydDEkMCIGA1UEAxMbRGlnaUNlcnQgVGlt
// SIG // ZXN0YW1wIDIwMjIgLSAyMIICIjANBgkqhkiG9w0BAQEF
// SIG // AAOCAg8AMIICCgKCAgEAz+ylJjrGqfJru43BDZrboegU
// SIG // hXQzGias0BxVHh42bbySVQxh9J0Jdz0Vlggva2Sk/QaD
// SIG // FteRkjgcMQKW+3KxlzpVrzPsYYrppijbkGNcvYlT4Dot
// SIG // jIdCriak5Lt4eLl6FuFWxsC6ZFO7KhbnUEi7iGkMiMbx
// SIG // vuAvfTuxylONQIMe58tySSgeTIAehVbnhe3yYbyqOgd9
// SIG // 9qtu5Wbd4lz1L+2N1E2VhGjjgMtqedHSEJFGKes+JvK0
// SIG // jM1MuWbIu6pQOA3ljJRdGVq/9XtAbm8WqJqclUeGhXk+
// SIG // DF5mjBoKJL6cqtKctvdPbnjEKD+jHA9QBje6CNk1prUe
// SIG // 2nhYHTno+EyREJZ+TeHdwq2lfvgtGx/sK0YYoxn2Off1
// SIG // wU9xLokDEaJLu5i/+k/kezbvBkTkVf826uV8MefzwlLE
// SIG // 5hZ7Wn6lJXPbwGqZIS1j5Vn1TS+QHye30qsU5Thmh1EI
// SIG // a/tTQznQZPpWz+D0CuYUbWR4u5j9lMNzIfMvwi4g14Gs
// SIG // 0/EH1OG92V1LbjGUKYvmQaRllMBY5eUuKZCmt2Fk+tkg
// SIG // bBhRYLqmgQ8JJVPxvzvpqwcOagc5YhnJ1oV/E9mNec9i
// SIG // xezhe7nMZxMHmsF47caIyLBuMnnHC1mDjcbu9Sx8e47L
// SIG // ZInxscS451NeX1XSfRkpWQNO+l3qRXMchH7XzuLUOncC
// SIG // AwEAAaOCAYswggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNV
// SIG // HRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMI
// SIG // MCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwH
// SIG // ATAfBgNVHSMEGDAWgBS6FtltTYUvcyl2mi91jGogj57I
// SIG // bzAdBgNVHQ4EFgQUYore0GH8jzEU7ZcLzT0qlBTfUpww
// SIG // WgYDVR0fBFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGln
// SIG // aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5
// SIG // NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYB
// SIG // BQUHAQEEgYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
// SIG // Y3NwLmRpZ2ljZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0
// SIG // cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
// SIG // VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGlu
// SIG // Z0NBLmNydDANBgkqhkiG9w0BAQsFAAOCAgEAVaoqGvNG
// SIG // 83hXNzD8deNP1oUj8fz5lTmbJeb3coqYw3fUZPwV+zbC
// SIG // SVEseIhjVQlGOQD8adTKmyn7oz/AyQCbEx2wmIncePLN
// SIG // fIXNU52vYuJhZqMUKkWHSphCK1D8G7WeCDAJ+uQt1wmJ
// SIG // efkJ5ojOfRu4aqKbwVNgCeijuJ3XrR8cuOyYQfD2DoD7
// SIG // 5P/fnRCn6wC6X0qPGjpStOq/CUkVNTZZmg9U0rIbf35e
// SIG // Ca12VIp0bcrSBWcrduv/mLImlTgZiEQU5QpZomvnIj5E
// SIG // IdI/HMCb7XxIstiSDJFPPGaUr10CU+ue4p7k0x+GAWSc
// SIG // AMLpWnR1DT3heYi/HAGXyRkjgNc2Wl+WFrFjDMZGQDvO
// SIG // XTXUWT5Dmhiuw8nLw/ubE19qtcfg8wXDWd8nYiveQclT
// SIG // uf80EGf2JjKYe/5cQpSBlIKdrAqLxksVStOYkEVgM4Dg
// SIG // I974A6T2RUflzrgDQkfoQTZxd639ouiXdE4u2h4djFrI
// SIG // HprVwvDGIqhPm73YHJpRxC+a9l+nJ5e6li6FV8Bg53hW
// SIG // f2rvwpWaSxECyIKcyRoFfLpxtU56mWz06J7UWpjIn7+N
// SIG // uxhcQ/XQKujiYu54BNu90ftbCqhwfvCXhHjjCANdRyxj
// SIG // qCU4lwHSPzra5eX25pvcfizM/xdMTQCi2NYBDriL7ubg
// SIG // clWJLCcZYfZ3AYwwggauMIIElqADAgECAhAHNje3JFR8
// SIG // 2Ees/ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNV
// SIG // BAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAX
// SIG // BgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
// SIG // GERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAz
// SIG // MjMwMDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7
// SIG // MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0
// SIG // MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0G
// SIG // CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPB
// SIG // PXJJUVXHJQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGh
// SIG // RBVCX6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9
// SIG // /UO0hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47q
// SIG // UT3w1lbU5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvb
// SIG // REGJ3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAsh
// SIG // aG43IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYb
// SIG // qMFkdECnwHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDET
// SIG // qVcplicu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1bicl
// SIG // kJg6OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9a
// SIG // bJTyUpURK1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZG
// SIG // s506o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1
// SIG // KCRB7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCON
// SIG // WPfcYd6T/jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGT
// SIG // yYwMO1uKIqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8e
// SIG // CXbsq11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a5
// SIG // 0g5rmQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/
// SIG // BAgwBgEB/wIBADAdBgNVHQ4EFgQUuhbZbU2FL3Mpdpov
// SIG // dYxqII+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5n
// SIG // P+e6mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQM
// SIG // MAoGCCsGAQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggr
// SIG // BgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
// SIG // MEEGCCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdp
// SIG // Y2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNy
// SIG // dDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5k
// SIG // aWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0
// SIG // LmNybDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
// SIG // hv1sBwEwDQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+Y
// SIG // qUQiAX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CK
// SIG // Daopafxpwc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKW
// SIG // b8RQTGIdDAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/
// SIG // q0+KLHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9
// SIG // nXzQcAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPBy
// SIG // oyP6wCeCRK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ
// SIG // 38SNoOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+j
// SIG // Sbl3ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5kn
// SIG // LD0/a6fxZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS
// SIG // 1yZr5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc
// SIG // 4d0j/R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmL
// SIG // NriT1ObyF5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDop
// SIG // hrCYoCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6
// SIG // gt4y3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvm
// SIG // fxqkhQ/8mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3
// SIG // OBqhK/bt1nz8MIIFjTCCBHWgAwIBAgIQDpsYjvnQLefv
// SIG // 21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQG
// SIG // EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
// SIG // VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtE
// SIG // aWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcNMjIw
// SIG // ODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYD
// SIG // VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkw
// SIG // FwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQD
// SIG // ExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0G
// SIG // CSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN67
// SIG // 5F1KPDAiMGkz7MKnJS7JIT3yithZwuEppz1Yq3aaza57
// SIG // G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1If
// SIG // xp4VpX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C
// SIG // 8weE5nQ7bXHiLQwb7iDVySAdYyktzuxeTsiT+CFhmzTr
// SIG // BcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
// SIG // T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5
// SIG // w3jHtrHEtWoYOAMQjdjUN6QuBX2I9YI+EJFwq1WCQTLX
// SIG // 2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC
// SIG // 5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2
// SIG // h4mXaXpI8OCiEhtmmnTK3kse5w5jrubU75KSOp493ADk
// SIG // RSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKy
// SIG // Ebe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfh
// SIG // vbfmQ6QYuKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZB
// SIG // dd56rF+NP8m800ERElvlEFDrMcXKchYiCd98THU/Y+wh
// SIG // X8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15Gkv
// SIG // mB0t9dmpsh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/
// SIG // BAUwAwEB/zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6
// SIG // mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6ch
// SIG // nfNtyA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEB
// SIG // BG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
// SIG // aWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
// SIG // ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVk
// SIG // SURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0
// SIG // dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
// SIG // c3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRV
// SIG // HSAAMA0GCSqGSIb3DQEBDAUAA4IBAQBwoL9DXFXnOF+g
// SIG // o3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi7aSI
// SIG // d229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre
// SIG // +i1Wz/n096wwepqLsl7Uz9FDRJtDIeuWcqFItJnLnU+n
// SIG // BgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcDx4eo0kxAGTVG
// SIG // amlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglo
// SIG // hJ9vytsgjTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyer
// SIG // bHbObyMt9H5xaiNrIv8SuFQtJ37YOtnwtoeW/VvRXKwY
// SIG // w02fc7cBqZ9Xql4o4rmUMYIDdjCCA3ICAQEwdzBjMQsw
// SIG // CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
// SIG // Yy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQg
// SIG // UlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAM
// SIG // TWlyS5T6PCpKPSkHgD1aMA0GCWCGSAFlAwQCAQUAoIHR
// SIG // MBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkq
// SIG // hkiG9w0BCQUxDxcNMjMwODAyMDMxMTQ0WjArBgsqhkiG
// SIG // 9w0BCRACDDEcMBowGDAWBBTzhyJNhjOCkjWplLy9j5bp
// SIG // /hx8czAvBgkqhkiG9w0BCQQxIgQgPFYW4c/YpxMQtOJE
// SIG // xHA95yOIHVp9W/9DLnpZldSVN1QwNwYLKoZIhvcNAQkQ
// SIG // Ai8xKDAmMCQwIgQgx/ThvjIoiSCr4iY6vhrE/E/meBwt
// SIG // ZNBMgHVXoCO1tvowDQYJKoZIhvcNAQEBBQAEggIAMww/
// SIG // MMHadEKXTNYksyAizUB4cUnjxS5MyijEhW5g1L9cbuHC
// SIG // dqrSkly4hm1HrGcTALtZMgPTjGUyQuqZ1ZCidBZl0laF
// SIG // U+CtgTkkKD4n/HJDcz1xwdxpwogVCu7NpS/6q5NiWCjK
// SIG // xSWc0hVyt/y8B80OWwpzu9HjqoUd7KMdxH/R/cionacP
// SIG // 3GPJC0TX6a98/X3u4UxvGI/8FUZ0zCyLnPLxNq8LRsip
// SIG // UBHOZEfll8pAMRDp0ubUWHZNzvW9ouCRdQqUXkvmvr+x
// SIG // OK8p4kiaTH/5FqV/WZxr1NChXCDFbcP01tuks59AiKpM
// SIG // x6aX2vxEPeRbQ/DxZimih6mTi7Gg25TY6aKI2ZWx8wJH
// SIG // OB/WX+2A6rHfVLexaFy/h2iySub3MCWKrajTYiMyOeqC
// SIG // impnxtwnjmjRSquNeW72CpF4W5j4o5LynyPeRYTdrblC
// SIG // QD1yKxsLWj3aUzVIKXsddqOsHplNaaRX1VLHtbXLkTDc
// SIG // IfIDvn+2KRGvBHBQea/GQDKUcjDiDQmNf3REiTFbq+kA
// SIG // Schx6AK76kLVme6Xk0RnnwIg+PcL3p0V7dSZlu7szMUl
// SIG // tbozk7DSu7g85OuO8H/95SjC9GJsMgQXbCkVZUlQinJ+
// SIG // gxh0qsjmJveBMmQY/lje/akmpPPrEgPLVd3MaBcCjzuv
// SIG // ePtc9njJAxzzBx5BUno=
// SIG // End signature block
